/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.codecs.AgriSoilVariant;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;

public record AgriSoil(List<String> mods, List<AgriSoilVariant> variants, AgriSoilCondition.Humidity humidity, AgriSoilCondition.Acidity acidity, AgriSoilCondition.Nutrients nutrients, Double growthModifier) implements MagnifyingInspectable
{
    public static final Codec<AgriSoil> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("mods").forGetter(soil -> soil.mods), (App)AgriSoilVariant.CODEC.listOf().fieldOf("variants").forGetter(soil -> soil.variants), (App)AgriSoilCondition.Humidity.CODEC.fieldOf("humidity").forGetter(soil -> soil.humidity), (App)AgriSoilCondition.Acidity.CODEC.fieldOf("acidity").forGetter(soil -> soil.acidity), (App)AgriSoilCondition.Nutrients.CODEC.fieldOf("nutrients").forGetter(soil -> soil.nutrients), (App)Codec.DOUBLE.fieldOf("growth_modifier").forGetter(soil -> soil.growthModifier)).apply((Applicative)instance, AgriSoil::new));

    public static Builder builder() {
        return new Builder();
    }

    public boolean isVariant(class_2680 blockState) {
        for (AgriSoilVariant variant : this.variants) {
            List<class_2248> blocks = Platform.get().getBlocksFromLocation(variant.block());
            if (!blocks.contains(blockState.method_26204())) continue;
            if (variant.states().isEmpty()) {
                return true;
            }
            Set list = blockState.method_11656().entrySet().stream().map(class_2688.field_24737).collect(Collectors.toSet());
            if (!list.containsAll(variant.states())) continue;
            return true;
        }
        return false;
    }

    public boolean isVariant(class_1792 item) {
        return this.variants.stream().flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).map(class_2248::method_8389).anyMatch(it -> it == item);
    }

    @Override
    public void addMagnifyingTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        tooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil"));
        tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.soil")).method_10852(LangUtils.soilName(AgriApi.getSoilId(this).map(class_2960::toString).orElse(""))));
        tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.humidity")).method_10852(LangUtils.soilPropertyName("humidity", this.humidity)));
        tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.acidity")).method_10852(LangUtils.soilPropertyName("acidity", this.acidity)));
        tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.nutrients")).method_10852(LangUtils.soilPropertyName("nutrients", this.nutrients)));
    }

    public static class Builder {
        List<String> mods = new ArrayList<String>();
        List<AgriSoilVariant> soilVariants = new ArrayList<AgriSoilVariant>();
        AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.INVALID;
        AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.INVALID;
        AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.INVALID;
        double growthModifier = 1.0;

        public AgriSoil build() {
            return new AgriSoil(this.mods, this.soilVariants, this.humidity, this.acidity, this.nutrients, this.growthModifier);
        }

        public Builder defaultMods() {
            Collections.addAll(this.mods, "agricraft", "minecraft");
            return this;
        }

        public Builder mods(String ... mods) {
            Collections.addAll(this.mods, mods);
            return this;
        }

        public Builder variants(AgriSoilVariant ... variants) {
            Collections.addAll(this.soilVariants, variants);
            return this;
        }

        public Builder humidity(AgriSoilCondition.Humidity humidity) {
            this.humidity = humidity;
            return this;
        }

        public Builder acidity(AgriSoilCondition.Acidity acidity) {
            this.acidity = acidity;
            return this;
        }

        public Builder nutrients(AgriSoilCondition.Nutrients nutrients) {
            this.nutrients = nutrients;
            return this;
        }

        public Builder growthModifier(double growthModifier) {
            this.growthModifier = growthModifier;
            return this;
        }
    }
}

